'##############################################################
'bewegungssensor2_pinchange.bas
'
'Ein kleines Testprogramm fr RN-AVR UNIVERSAL (ATMega644)
'und Bewegungssenor PIR SE10 von Robotikhardware.de
'Das Programm demonstriert wie man mit einem kleinem
'kompakten PIR-Sensor Bewegung in einem Raum erkennen kann
'Sobald die geringste Bewegung erkannt wird, wird dies ber RS232 ausgegeben
'
'Der Vorteil dieses Programmes ist, das der Bewegungsmelder nicht
'stndig abgefragt werden muss, da der Pin Change Interrupt
'ausgenutzt wird. Der Controller kann also nebenher etwas anderes machen.
'Die Led leuchtet ebenfalls bei Bewegung auf
'
' (c) Frank Brall 2013
'Weitere Beispiele auf DVD von robotikhardware.de
'oder im www.Roboternetz.de und rn-wissen.de

'######################################################################

'Portbelegung:
'PIR SE10 Alarmkontakt an PA0
'PIR GND nach GND
'PIR + nach POW+ (Batterie 4 Mignon)
'Pullup-Widerstand 33k von PA0 nach POW+
'Werteausgabe ber RS232/USB


Declare Function PIRAbfragen()  as byte


$programmer = 12                    'MCS USB  (Zeile weglassen wenn anderer Programmer)
$prog &HFF , &HFF , &HD9 , &HFE      'Fusebits richtig programmieren (Quarz ein,Jtag aus)

$regfile = "m644pdef.dat" ' oder $regfile = "m644def.dat"
$framesize = 64
$swstack = 64
$hwstack = 64

$crystal = 8000000                                          'Quarzfrequenz


Config Pind.6 = Output                                      'LED
Led1 Alias Portd.6


Config Pina.0 = Input
PIR Alias Pina.0


On Pcint0 Isr_Bewegung
Enable Pcint0
Pcmsk0 = &B00000001  'Interrupt fr PIN PA0 PCINT0 zulassen
enable interrupts


dim bewegung as byte

led1=1 'led aus
wait 3  '2 Sekunden warten - kalibrierung Sensor auf Hintergrund
Do

    if bewegung=1 then
      print "Bewegung wurde erkannt !"
      wait 2  'Warten
      bewegung=0 'Gemerkte Bewegung zurckstellen da ausgewertet
      led1=1 'led wieder aus
    endif
    waitms 500
Loop




'Diesser Interrupt wird ausgelst wenn PIR Bewegung meldet
'genauer gesagt: wenn PA0 den Pegel wechselt
Isr_Bewegung:
  if PIR=0 then
    bewegung=1
    Led1=0 'led ein
  endif
return